@extends('layouts.app')

@section('title', 'Login')

@section('content')
<div class="container col-md-4">
    <h3 class="mb-3">Login</h3>

    <form method="POST" action="{{ url('/login') }}">
        @csrf

        <div class="mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>

        <div class="mb-3">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button class="btn btn-primary w-100">Login</button>

        <p class="mt-3 text-center">
            No account? <a href="{{ route('register') }}">Register</a>
        </p>
    </form>
    <hr>

<form method="POST" action="{{ route('login.guest') }}">
    @csrf
    <button type="submit" class="btn btn-secondary w-100">
        Login as Guest
    </button>
</form>
</div>

@endsection