<?php $__env->startSection("title", "Posts"); ?>

<?php $__env->startSection("content"); ?>

<a href="<?php echo e(route('posts.create')); ?>" class="btn btn-primary mb-3">
    Add New Post
</a>

<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>លេខរៀង</th>
            <th>Title</th>
            <th>Category</th>
            <th>Author</th>
            <th>Image</th>
            <th>Content</th>
            <th>Status</th>
            <th>សកម្មភាព</th>
        </tr>
    </thead>

    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>

                <td><?php echo e($post->title); ?></td>

                <td><?php echo e($post->category->name ?? 'No Category'); ?></td>

                <td><?php echo e($post->user->name ?? 'Guest'); ?></td>

                <td>
                    <img src="<?php echo e($post->image && file_exists(public_path('storage/' . $post->image))
                        ? asset('storage/' . $post->image)
                        : asset('images/no_image.png')); ?>"
                        alt="<?php echo e($post->title); ?>"
                        width="50"
                        height="50">
                </td>
                <td>
                    <?php echo e($post->content ?? 'No Content'); ?>

                </td>

                <td>
                    <span class="badge
                        <?php echo e($post->status == 'published' ? 'bg-primary'
                        : ($post->status == 'draft' ? 'bg-warning' : 'bg-secondary')); ?>">
                        <?php echo e(ucfirst($post->status)); ?>

                    </span>
                </td>

                <td>
                    <a href="<?php echo e(route('posts.show', $post->id)); ?>"
                        class="btn btn-info btn-sm">Detail</a>

                    <?php if(auth()->guard()->check()): ?>
                    <?php if(auth()->user()->role === 'admin' || auth()->id() === $post->user_id): ?>
                        <a href="<?php echo e(route('posts.edit', $post->id)); ?>" class="btn btn-warning btn-sm">
                            Edit
                        </a>

                        <form action="<?php echo e(route('posts.destroy', $post->id)); ?>"
                            method="POST"
                            class="d-inline"
                            onsubmit="return confirm('Are you sure you want to delete this category?');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    <?php endif; ?>
                    <?php endif; ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" class="text-center">
                    មិនមានទិន្នន័យ
                </td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

<div class="d-flex justify-content-center">
    <?php echo e($posts->links()); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.app", array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/Desktop/blogApp/resources/views/posts/index.blade.php ENDPATH**/ ?>